<?php $__env->startPush('style'); ?>
<style>
    .header-style-two {
        background: rgba(40, 60, 71, 0.40);
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>


<section class="contact-form">
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="contact-form-left-container">
                    <div class="contact-form-left-image">
                        <img src="<?php echo e(asset('frontend/images/contact-us.png')); ?>" alt="Contact Image">
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="contact-form-right-container">
                    <h3 class="mb_10"><?php echo app('translator')->get('app.get-in-touch'); ?></h3>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="mb-0"><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <form action="<?php echo e(route('contact')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <input type="text"
                                       name="name"
                                       class="contact-input"
                                       value="<?php echo e(old('name')); ?>"
                                       placeholder="<?php echo app('translator')->get('app.your'); ?> <?php echo app('translator')->get('app.name'); ?>">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="email"
                                       name="email"
                                       class="contact-input"
                                       value="<?php echo e(old('email')); ?>"
                                       placeholder="<?php echo app('translator')->get('app.your'); ?> <?php echo app('translator')->get('app.email'); ?>">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="tel"
                                       name="phone"
                                       class="contact-input"
                                       value="<?php echo e(old('phone')); ?>"
                                       placeholder="<?php echo app('translator')->get('app.your'); ?> <?php echo app('translator')->get('app.phone'); ?>">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="text"
                                       name="subject"
                                       class="contact-input"
                                       value="<?php echo e(old('subject')); ?>"
                                       placeholder="<?php echo app('translator')->get('app.subject'); ?>">
                            </div>
                            <div class="col-lg-12 mb-3">
                                <textarea name="message"
                                          class="contact-input"
                                          placeholder="<?php echo app('translator')->get('app.write-your-message'); ?>"><?php echo e(old('message')); ?></textarea>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input contactCur"
                                           name="check"
                                           value="1"
                                           type="checkbox"
                                           id="subscribe"
                                           <?php echo e(old('check') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="subscribe">
                                        <?php echo app('translator')->get('app.select-to-subscribe'); ?>
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <button type="submit" class="btn-1 w-100">
                                    <?php echo app('translator')->get('app.submit'); ?>
                                    <i class="fas fa-paper-plane ms-2"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="contact-info">
    <div class="container">
        <div class="row">
            <div class="col-xl-3 col-lg-4 col-md-6 offset-xl-1">
                <div class="contact-info-content">
                    <div class="icon">
                        <i class="fa-light fa-location-dot"></i>
                    </div>
                    <div class="content">
                        <h6>16/A,Romadan House City Tower New York,USA</h6>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="contact-info-content">
                    <div class="icon">
                        <i class="fa-light fa-phone"></i>
                    </div>
                    <div class="content">
                        <a href="tel:<?php echo e(setting('sitephone')); ?>"><?php echo e(setting('sitephone')); ?></a>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="contact-info-content">
                    <div class="icon">
                        <i class="fa-light fa-envelope"></i>
                    </div>
                    <div class="content">
                        <a href="mailto:<?php echo e(setting('email')); ?>"><?php echo e(setting('email')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="contact-map">
    <div class="container">
        <div class="rpw">
            <div class="col-lg-12">
                <div class="destination-details-map">
                    <h5 class="destination-details-common-title">
                        <?php echo app('translator')->get('app.our-location'); ?>
                    </h5>
                    <div class="map-container">
                            <iframe class="mapIn" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4339.963605701106!2d90.37604191636046!3d23.76702410183389!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c7543a947b03%3A0xd75e6a88605a6663!2sChandrima%20Udyan!5e0!3m2!1sen!2sbd!4v1737302676312!5m2!1sen!2sbd" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/frontend/pages/contact.blade.php ENDPATH**/ ?>